/*
 * ##/%% variable matching code ripped out of ash shell for code sharing
 *
 * This code is derived from software contributed to Berkeley by
 * Kenneth Almquist.
 *
 * Licensed under GPLv2 or later, see file LICENSE in this source tree.
 *
 * Copyright (c) 1989, 1991, 1993, 1994
 *      The Regents of the University of California.  All rights reserved.
 *
 * Copyright (c) 1997-2005 Herbert Xu <herbert@gondor.apana.org.au>
 * was re-ported from NetBSD and debianized.
 */
#include "libbb.h"
#include <fnmatch.h>
#include "match.h"
char* FAST_FUNC scan_and_match(char *string, const char *pattern, unsigned flags)
{
	char *loc;
	char *end;
	unsigned len = strlen(string);
	int early_exit;
	/* We can stop the scan early only if the string part
	 * we are matching against is shrinking, and the pattern has
	 * an unquoted "star" at the corresponding end. There are two cases.
	 * Case 1:
	 * "qwerty" does not match against pattern "*zy",
	 * no point in trying to match "werty", "erty" etc:
	 */
	early_exit = (flags == (SCAN_MOVE_FROM_LEFT + SCAN_MATCH_RIGHT_HALF) && pattern[0] == '*');
	if (flags & SCAN_MOVE_FROM_LEFT) {
		loc = string;
		end = string + len + 1;
	} else {
		loc = string + len;
		end = string - 1;
		if (flags == (SCAN_MOVE_FROM_RIGHT + SCAN_MATCH_LEFT_HALF)) {
			/* Case 2:
			 * "qwerty" does not match against pattern "qz*",
			 * no point in trying to match "qwert", "qwer" etc:
			 */
			const char *p = pattern + strlen(pattern);
			if (--p >= pattern && *p == '*') {
				early_exit = 1;
				while (--p >= pattern && *p == '\\')
					early_exit ^= 1;
			}
		}
	}
	while (loc != end) {
		int r;
		if (flags & SCAN_MATCH_LEFT_HALF) {
			char c = *loc;
			*loc = '\0';
			r = fnmatch(pattern, string, 0);
			//bb_error_msg("fnmatch('%s','%s',0):%d", pattern, string, r);
			*loc = c;
		} else {
			r = fnmatch(pattern, loc, 0);
			//bb_error_msg("fnmatch('%s','%s',0):%d", pattern, loc, r);
		}
		if (r == 0) /* match found */
			return loc;
		if (early_exit) {
			break;
		}
		if (flags & SCAN_MOVE_FROM_LEFT) {
			loc++;
		} else {
			loc--;
		}
	}
	return NULL;
}
