/*
 * Copyright (C) 2017 Denys Vlasenko
 *
 * Licensed under GPLv2, see file LICENSE in this source tree.
 */
#include "tls.h"
/* The file is taken almost verbatim from matrixssl-3-7-2b-open/crypto/math/.
 * Changes are flagged with //bbox
 */
/**
 *	@file    pstm_mul_comba.c
 *	@version 33ef80f (HEAD, tag: MATRIXSSL-3-7-2-OPEN, tag: MATRIXSSL-3-7-2-COMM, origin/master, origin/HEAD, master)
 *
 *	Multiprecision multiplication with Comba technique.
 */
/*
 *	Copyright (c) 2013-2015 INSIDE Secure Corporation
 *	Copyright (c) PeerSec Networks, 2002-2011
 *	All Rights Reserved
 *
 *	The latest version of this code is available at http://www.matrixssl.org
 *
 *	This software is open source; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This General Public License does NOT permit incorporating this software
 *	into proprietary programs.  If you are unable to comply with the GPL, a
 *	commercial license for this software may be purchased from INSIDE at
 *	http://www.insidesecure.com/eng/Company/Locations
 *
 *	This program is distributed in WITHOUT ANY WARRANTY; without even the
 *	implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *	http://www.gnu.org/copyleft/gpl.html
 */
/******************************************************************************/
//bbox
//#include "../cryptoApi.h"
/******************************************************************************/
#define COMBA_START 
#define COMBA_CLEAR c0 = c1 = c2 = 0;
#define COMBA_FORWARD do { c0 = c1; c1 = c2; c2 = 0; } while (0);
#define COMBA_STORE(x) x = c0;
#define COMBA_STORE2(x) x = c1;
#define COMBA_FINI 
#define MULADD(i,j) do { pstm_word t; t = (pstm_word)c0 + ((pstm_word)i) * ((pstm_word)j); c0 = (pstm_digit)t; t = (pstm_word)c1 + (t >> DIGIT_BIT); c1 = (pstm_digit)t; c2 += (pstm_digit)(t >> DIGIT_BIT); } while (0);
/******************************************************************************/
/* generic PxQ multiplier */
//bbox: pool unused
#define pstm_mul_comba_gen(pool,A,B,C,paD,paDlen) pstm_mul_comba_gen( A, B, C, paD, paDlen)
static int32 pstm_mul_comba_gen(psPool_t *pool, pstm_int *A, pstm_int *B,
			pstm_int *C, pstm_digit *paD, uint32 paDlen)
{
	int		paDfail, pa; //bbox: was int16
	int32       ix, iy, iz, tx, ty;
	pstm_digit	c0, c1, c2, *tmpx, *tmpy, *dst;
	COMBA_START;
	COMBA_CLEAR;
	paDfail = 0;
	/* get size of output and trim */
	pa = A->used + B->used;
/*
	If c is not large enough grow it and continue
*/
	if (C->alloc < pa) {
		if (pstm_grow(C, pa) != PSTM_OKAY) {
			return PS_MEM_FAIL;
		}
	}
	if (paD != NULL) {
		if (paDlen < (sizeof(pstm_digit) * pa)) {
			paDfail = 1; /* have a paD but it's not large enough */
			dst = xzalloc(sizeof(pstm_digit) * pa);//bbox
		} else {
			dst = paD;
			memset(dst, 0x0, paDlen);
		}
	} else {
		dst = xzalloc(sizeof(pstm_digit) * pa);//bbox
	}
	for (ix = 0; ix < pa; ix++) {
		/* get offsets into the two bignums */
		ty = min(ix, B->used-1);
		tx = ix - ty;
		/* setup temp aliases */
		tmpx = A->dp + tx;
		tmpy = B->dp + ty;
/*
		This is the number of times the loop will iterate, essentially it's
			while (tx++ < a->used && ty-- >= 0) { ... }
*/
		iy = min(A->used-tx, ty+1);
		/* execute loop */
		COMBA_FORWARD;
		for (iz = 0; iz < iy; ++iz) {
			MULADD(*tmpx++, *tmpy--);
		}
		/* store term */
		COMBA_STORE(dst[ix]);
	}
	COMBA_FINI;
/*
	setup dest
 */
	iy  = C->used;
	C->used = pa;
	C->sign = A->sign ^ B->sign;
	{
		pstm_digit *tmpc;
		tmpc = C->dp;
		for (ix = 0; ix < pa; ix++) {
			*tmpc++ = dst[ix];
		}
/*
		clear unused digits [that existed in the old copy of c]
 */
		for (; ix < iy; ix++) {
			*tmpc++ = 0;
		}
	}
	pstm_clamp(C);
	if ((paD == NULL) || (paDfail == 1)) {
		psFree(dst, pool);
	}
	return PS_SUCCESS;
}
/******************************************************************************/
/******************************************************************************/
int32 FAST_FUNC pstm_mul_comba(psPool_t *pool, pstm_int *A, pstm_int *B, pstm_int *C,
			pstm_digit *paD, uint32 paDlen)
{
	return pstm_mul_comba_gen(pool, A, B, C, paD, paDlen);
}
/******************************************************************************/
