/*
 * Copyright (C) 2018 Denys Vlasenko
 *
 * Licensed under GPLv2, see file LICENSE in this source tree.
 */
#include "tls.h"
typedef uint8_t byte;
typedef uint32_t word32;
#define XMEMSET memset
#define XMEMCPY memcpy
/* from wolfssl-3.15.3/wolfcrypt/src/aes.c */
static void RIGHTSHIFTX(byte* x)
{
#define l ((unsigned long*)x)
    // In order to use word-sized ops, little-endian needs to byteswap.
    // On x86, code size increase is ~10 bytes compared to byte-by-byte.
    unsigned long carryIn = (x[15] & 0x01)
        ? ((unsigned long)0xE1 << (LONG_BIT-8))
        : 0;
    // 64-bit code: need to process only 2 words
    unsigned long tt = SWAP_BE64(l[0]);
    unsigned long carryOut = tt << (LONG_BIT-1); // zero, or 0x800..00
    tt = (tt >> 1) ^ carryIn; l[0] = SWAP_BE64(tt);
    tt = SWAP_BE64(l[1]);
    tt = (tt >> 1) ^ carryOut; l[1] = SWAP_BE64(tt);
#undef l
}
// Caller guarantees X is aligned
static void GMULT(byte* X, byte* Y)
{
    byte Z[AES_BLOCK_SIZE] ALIGNED_long;
    //byte V[AES_BLOCK_SIZE] ALIGNED_long;
    int i;
    XMEMSET(Z, 0, AES_BLOCK_SIZE);
    //XMEMCPY(V, X, AES_BLOCK_SIZE);
    for (i = 0; i < AES_BLOCK_SIZE; i++) {
        uint32_t y = 0x800000 | Y[i];
        for (;;) { // for every bit in Y[i], from msb to lsb
            if (y & 0x80) {
                xorbuf_aligned_AES_BLOCK_SIZE(Z, X); // was V, not X
            }
            RIGHTSHIFTX(X); // was V, not X
            y = y << 1;
            if ((int32_t)y < 0) // if bit 0x80000000 set = if 8 iterations done
                break;
        }
    }
    XMEMCPY(X, Z, AES_BLOCK_SIZE);
}
//bbox:
// for TLS AES-GCM, a (which is AAD) is always 13 bytes long, and bbox code provides
// extra 3 zeroed bytes, making it a[16], or a[AES_BLOCK_SIZE].
// Resulting auth tag in s[] is also always AES_BLOCK_SIZE bytes.
//
// This allows some simplifications.
#define aSz 13
#define sSz AES_BLOCK_SIZE
void FAST_FUNC aesgcm_GHASH(byte* h,
    const byte* a, //unsigned aSz,
    const byte* c, unsigned cSz,
    byte* s //, unsigned sSz
)
{
    byte x[AES_BLOCK_SIZE] ALIGNED_long;
//    byte scratch[AES_BLOCK_SIZE] ALIGNED_long;
    unsigned blocks, partial;
    //was: byte* h = aes->H;
    //XMEMSET(x, 0, AES_BLOCK_SIZE);
    /* Hash in A, the Additional Authentication Data */
//    if (aSz != 0 && a != NULL) {
//        blocks = aSz / AES_BLOCK_SIZE;
//        partial = aSz % AES_BLOCK_SIZE;
//        while (blocks--) {
            //xorbuf(x, a, AES_BLOCK_SIZE);
            XMEMCPY(x, a, AES_BLOCK_SIZE);// memcpy(x,a) = memset(x,0)+xorbuf(x,a)
            GMULT(x, h);
//            a += AES_BLOCK_SIZE;
//        }
//        if (partial != 0) {
//            XMEMSET(scratch, 0, AES_BLOCK_SIZE);
//            XMEMCPY(scratch, a, partial);
//            xorbuf(x, scratch, AES_BLOCK_SIZE);
//            GMULT(x, h);
//        }
//    }
    /* Hash in C, the Ciphertext */
    if (cSz != 0 /*&& c != NULL*/) {
        blocks = cSz / AES_BLOCK_SIZE;
        partial = cSz % AES_BLOCK_SIZE;
        while (blocks--) {
            if (BB_UNALIGNED_MEMACCESS_OK) // c is not guaranteed to be aligned
                xorbuf_aligned_AES_BLOCK_SIZE(x, c);
            else
                xorbuf(x, c, AES_BLOCK_SIZE);
            GMULT(x, h);
            c += AES_BLOCK_SIZE;
        }
        if (partial != 0) {
            //XMEMSET(scratch, 0, AES_BLOCK_SIZE);
            //XMEMCPY(scratch, c, partial);
            //xorbuf(x, scratch, AES_BLOCK_SIZE);
            xorbuf(x, c, partial);//same result as above
            GMULT(x, h);
        }
    }
    /* Hash in the lengths of A and C in bits */
    //FlattenSzInBits(&scratch[0], aSz);
    //FlattenSzInBits(&scratch[8], cSz);
    //xorbuf_aligned_AES_BLOCK_SIZE(x, scratch);
    // simpler:
#define P32(v) ((uint32_t*)v)
  //P32(x)[0] ^= 0;
    P32(x)[1] ^= SWAP_BE32(aSz * 8);
  //P32(x)[2] ^= 0;
    P32(x)[3] ^= SWAP_BE32(cSz * 8);
#undef P32
    GMULT(x, h);
    /* Copy the result into s. */
    XMEMCPY(s, x, sSz);
}
