/* vi: set sw=4 ts=4: */
/*
 * Busybox utility routines.
 *
 * Copyright (C) 2005 by Tito Ragusa <tito-wolit@tiscali.it>
 *
 * Licensed under GPLv2, see file LICENSE in this source tree.
 */
#include "libbb.h"
/* void FAST_FUNC bb_do_delay(unsigned seconds) { ... } - no users yet */
#define LOGIN_FAIL_DELAY 3
void FAST_FUNC pause_after_failed_login(void)
{
	sleep(LOGIN_FAIL_DELAY);
}
void FAST_FUNC sleep1(void)
{
	sleep(1);
}
void FAST_FUNC msleep(unsigned ms)
{
//usleep is often implemented as a call to nanosleep.
//Simply do the same to implement msleep.
//it's marginally larger, but wakes your CPU less often:
//function    old     new   delta
//msleep       45      52      +7
	struct timespec ts;
	ts.tv_sec = ms / 1000;
	ts.tv_nsec = (ms % 1000) * 1000000;
	/*
	 * If a signal has non-default handler, nanosleep returns early.
	 * Our version of msleep doesn't return early
	 * if interrupted by such signals:
	 */
	while (nanosleep(&ts, &ts) != 0)
		continue;
}
