#ifndef __STATVFS_H__
#define __STATVFS_H__
/* Definitions for getting information about a filesystem.
   Copyright (C) 1998-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
#define _SYS_STATVFS_H 1
/* Get the system-specific definition of `struct statfs'.  */
#include <bits/statvfs.h>
typedef __fsblkcnt64_t fsblkcnt_t; /* Type to count file system blocks.  */
#define __fsblkcnt_t_defined 
typedef __fsfilcnt64_t fsfilcnt_t; /* Type to count file system inodes.  */
#define __fsfilcnt_t_defined 
__BEGIN_DECLS
/* Return information about the filesystem on which FILE resides.  */
extern int __REDIRECT_NTH (statvfs,
			   (const char *__restrict __file,
			    struct statvfs *__restrict __buf), statvfs64)
     __nonnull ((1, 2));
extern int statvfs64 (const char *__restrict __file,
		      struct statvfs64 *__restrict __buf)
     __THROW __nonnull ((1, 2));
/* Return information about the filesystem containing the file FILDES
   refers to.  */
extern int __REDIRECT_NTH (fstatvfs, (int __fildes, struct statvfs *__buf),
			   fstatvfs64) __nonnull ((2));
extern int fstatvfs64 (int __fildes, struct statvfs64 *__buf)
     __THROW __nonnull ((2));
__END_DECLS
#endif /* __STATVFS_H__ */
