#ifndef __PARAM_H__
#define __PARAM_H__
/* Compatibility header for old-style Unix parameters and limits.
   Copyright (C) 1995-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
#define _SYS_PARAM_H 1
#define __need_NULL 
#include <stddef.h>
#include <limits.h>
/* This file defines some things in system-specific ways.  */
#include <bits/param.h>
/* BSD names for some <limits.h> values.  */
#define NBBY CHAR_BIT
#define NGROUPS NGROUPS_MAX
#define CANBSIZ MAX_CANON
#define MAXPATHLEN PATH_MAX
/* Magical constants.  */
#define NODEV ((dev_t) -1)
/* Unit of `st_blocks'.  */
#define DEV_BSIZE 512
/* Bit map related macros.  */
#define setbit(a,i) ((a)[(i)/NBBY] |= 1<<((i)%NBBY))
#define clrbit(a,i) ((a)[(i)/NBBY] &= ~(1<<((i)%NBBY)))
#define isset(a,i) ((a)[(i)/NBBY] & (1<<((i)%NBBY)))
#define isclr(a,i) (((a)[(i)/NBBY] & (1<<((i)%NBBY))) == 0)
/* Macros for counting and rounding.  */
#define howmany(x,y) (((x) + ((y) - 1)) / (y))
#define roundup(x,y) (__builtin_constant_p (y) && powerof2 (y) ? (((x) + (y) - 1) & ~((y) - 1)) : ((((x) + ((y) - 1)) / (y)) * (y)))
#define powerof2(x) ((((x) - 1) & (x)) == 0)
/* Macros for min/max.  */
#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif /* __PARAM_H__ */
