#ifndef __WAITFLAGS_H__
#define __WAITFLAGS_H__
/* Definitions of flag bits for `waitpid' et al.
   Copyright (C) 1992-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
/* Bits in the third argument to `waitpid'.  */
#define WNOHANG 1
#define WUNTRACED 2
/* Bits in the fourth argument to `waitid'.  */
#define WSTOPPED 2
#define WEXITED 4
#define WCONTINUED 8
#define WNOWAIT 0x01000000
#define __WNOTHREAD 0x20000000
#define __WALL 0x40000000
#define __WCLONE 0x80000000
/* The following values are used by the `waitid' function.  */
#define __ENUM_IDTYPE_T 1
/* The Linux kernel defines these bare, rather than an enum,
   which causes a conflict if the include order is reversed. */
#undef P_ALL
#undef P_PID
#undef P_PGID
typedef enum
{
  P_ALL,		/* Wait for any child.  */
  P_PID,		/* Wait for specified process.  */
  P_PGID		/* Wait for members of process group.  */
} idtype_t;
#endif /* __WAITFLAGS_H__ */
