#ifndef __TIMEX_H__
#define __TIMEX_H__
/* Copyright (C) 1995-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
#define _BITS_TIMEX_H 1
/* These definitions from linux/timex.h as of 3.18.  */
struct timex
{
  unsigned int modes;		/* mode selector */
  __syscall_slong_t offset;	/* time offset (usec) */
  __syscall_slong_t freq;	/* frequency offset (scaled ppm) */
  __syscall_slong_t maxerror;	/* maximum error (usec) */
  __syscall_slong_t esterror;	/* estimated error (usec) */
  int status;			/* clock command/status */
  __syscall_slong_t constant;	/* pll time constant */
  __syscall_slong_t precision;	/* clock precision (usec) (ro) */
  __syscall_slong_t tolerance;	/* clock frequency tolerance (ppm) (ro) */
  struct timeval time;		/* (read only, except for ADJ_SETOFFSET) */
  __syscall_slong_t tick;	/* (modified) usecs between clock ticks */
  __syscall_slong_t ppsfreq;	/* pps frequency (scaled ppm) (ro) */
  __syscall_slong_t jitter;	/* pps jitter (us) (ro) */
  int shift;			/* interval duration (s) (shift) (ro) */
  __syscall_slong_t stabil;	/* pps stability (scaled ppm) (ro) */
  __syscall_slong_t jitcnt;	/* jitter limit exceeded (ro) */
  __syscall_slong_t calcnt;	/* calibration intervals (ro) */
  __syscall_slong_t errcnt;	/* calibration errors (ro) */
  __syscall_slong_t stbcnt;	/* stability limit exceeded (ro) */
  int tai;			/* TAI offset (ro) */
  /* ??? */
  int  :32; int  :32; int  :32; int  :32;
  int  :32; int  :32; int  :32; int  :32;
  int  :32; int  :32; int  :32;
};
/* Mode codes (timex.mode) */
#define ADJ_OFFSET 0x0001
#define ADJ_FREQUENCY 0x0002
#define ADJ_MAXERROR 0x0004
#define ADJ_ESTERROR 0x0008
#define ADJ_STATUS 0x0010
#define ADJ_TIMECONST 0x0020
#define ADJ_TAI 0x0080
#define ADJ_SETOFFSET 0x0100
#define ADJ_MICRO 0x1000
#define ADJ_NANO 0x2000
#define ADJ_TICK 0x4000
#define ADJ_OFFSET_SINGLESHOT 0x8001
#define ADJ_OFFSET_SS_READ 0xa001
/* xntp 3.4 compatibility names */
#define MOD_OFFSET ADJ_OFFSET
#define MOD_FREQUENCY ADJ_FREQUENCY
#define MOD_MAXERROR ADJ_MAXERROR
#define MOD_ESTERROR ADJ_ESTERROR
#define MOD_STATUS ADJ_STATUS
#define MOD_TIMECONST ADJ_TIMECONST
#define MOD_CLKB ADJ_TICK
#define MOD_CLKA ADJ_OFFSET_SINGLESHOT
#define MOD_TAI ADJ_TAI
#define MOD_MICRO ADJ_MICRO
#define MOD_NANO ADJ_NANO
/* Status codes (timex.status) */
#define STA_PLL 0x0001
#define STA_PPSFREQ 0x0002
#define STA_PPSTIME 0x0004
#define STA_FLL 0x0008
#define STA_INS 0x0010
#define STA_DEL 0x0020
#define STA_UNSYNC 0x0040
#define STA_FREQHOLD 0x0080
#define STA_PPSSIGNAL 0x0100
#define STA_PPSJITTER 0x0200
#define STA_PPSWANDER 0x0400
#define STA_PPSERROR 0x0800
#define STA_CLOCKERR 0x1000
#define STA_NANO 0x2000
#define STA_MODE 0x4000
#define STA_CLK 0x8000
/* Read-only bits */
#define STA_RONLY (STA_PPSSIGNAL | STA_PPSJITTER | STA_PPSWANDER | STA_PPSERROR | STA_CLOCKERR | STA_NANO | STA_MODE | STA_CLK)
#endif /* __TIMEX_H__ */
