#ifndef __MATH_H__
#define __MATH_H__
/* Declarations for math functions.
   Copyright (C) 1991-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
/*
 *	ISO C99 Standard: 7.12 Mathematics	<math.h>
 */
#define _MATH_H 1
#define __GLIBC_INTERNAL_STARTING_HEADER_IMPLEMENTATION 
#include <bits/libc-header-start.h>
__BEGIN_DECLS
/* Get definitions of __intmax_t and __uintmax_t.  */
/* Get machine-dependent vector math functions declarations.  */
#include <bits/math-vector.h>
/* Gather machine dependent type support.  */
/* Value returned on overflow.  With IEEE 754 floating point, this is
   +Infinity, otherwise the largest representable positive value.  */
#define HUGE_VAL (__builtin_huge_val ())
#define HUGE_VALF (__builtin_huge_valf ())
#define HUGE_VALL (__builtin_huge_vall ())
#define HUGE_VAL_F32 (__builtin_huge_valf32 ())
#define HUGE_VAL_F64 (__builtin_huge_valf64 ())
#define HUGE_VAL_F128 (__builtin_huge_valf128 ())
#define HUGE_VAL_F32X (__builtin_huge_valf32x ())
#define HUGE_VAL_F64X (__builtin_huge_valf64x ())
/* IEEE positive infinity.  */
#define INFINITY (__builtin_inff ())
/* IEEE Not A Number.  */
#define NAN (__builtin_nanf (""))
/* Signaling NaN macros, if supported.  */
#define SNANF (__builtin_nansf (""))
#define SNAN (__builtin_nans (""))
#define SNANL (__builtin_nansl (""))
#define SNANF32 (__builtin_nansf32 (""))
#define SNANF64 (__builtin_nansf64 (""))
#define SNANF128 (__builtin_nansf128 (""))
#define SNANF32X (__builtin_nansf32x (""))
#define SNANF64X (__builtin_nansf64x (""))
/* Get __GLIBC_FLT_EVAL_METHOD.  */
#include <bits/flt-eval-method.h>
/* Define the following typedefs.
    float_t	floating-point type at least as wide as `float' used
		to evaluate `float' expressions
    double_t	floating-point type at least as wide as `double' used
		to evaluate `double' expressions
*/
typedef float float_t;
typedef double double_t;
/* Define macros for the return values of ilogb and llogb, based on
   __FP_LOGB0_IS_MIN and __FP_LOGBNAN_IS_MIN.
    FP_ILOGB0	Expands to a value returned by `ilogb (0.0)'.
    FP_ILOGBNAN	Expands to a value returned by `ilogb (NAN)'.
    FP_LLOGB0	Expands to a value returned by `llogb (0.0)'.
    FP_LLOGBNAN	Expands to a value returned by `llogb (NAN)'.
*/
#include <bits/fp-logb.h>
#define FP_ILOGB0 (-2147483647 - 1)
#define FP_ILOGBNAN (-2147483647 - 1)
#define __FP_LONG_MAX 0x7fffffffffffffffL
#define FP_LLOGB0 (-__FP_LONG_MAX - 1)
#define FP_LLOGBNAN (-__FP_LONG_MAX - 1)
/* Get the architecture specific values describing the floating-point
   evaluation.  The following symbols will get defined:
    FP_FAST_FMA
    FP_FAST_FMAF
    FP_FAST_FMAL
		If defined it indicates that the `fma' function
		generally executes about as fast as a multiply and an add.
		This macro is defined only iff the `fma' function is
		implemented directly with a hardware multiply-add instructions.
*/
#include <bits/fp-fast.h>
/* Rounding direction macros for fromfp functions.  */
enum
  {
    FP_INT_UPWARD =
#define FP_INT_UPWARD 0
      FP_INT_UPWARD,
    FP_INT_DOWNWARD =
#define FP_INT_DOWNWARD 1
      FP_INT_DOWNWARD,
    FP_INT_TOWARDZERO =
#define FP_INT_TOWARDZERO 2
      FP_INT_TOWARDZERO,
    FP_INT_TONEARESTFROMZERO =
#define FP_INT_TONEARESTFROMZERO 3
      FP_INT_TONEARESTFROMZERO,
    FP_INT_TONEAREST =
#define FP_INT_TONEAREST 4
      FP_INT_TONEAREST,
  };
/* The file <bits/mathcalls.h> contains the prototypes for all the
   actual math functions.  These macros are used for those prototypes,
   so we can easily declare each function as both `name' and `__name',
   and can declare the float versions `namef' and `__namef'.  */
#define __SIMD_DECL(function) __CONCAT (__DECL_SIMD_, function)
#define __MATHCALL_VEC(function,suffix,args) __SIMD_DECL (__MATH_PRECNAME (function, suffix)) __MATHCALL (function, suffix, args)
#define __MATHDECL_VEC(type,function,suffix,args) __SIMD_DECL (__MATH_PRECNAME (function, suffix)) __MATHDECL(type, function,suffix, args)
#define __MATHCALL(function,suffix,args) __MATHDECL (_Mdouble_,function,suffix, args)
#define __MATHDECL(type,function,suffix,args) __MATHDECL_1(type, function,suffix, args); __MATHDECL_1(type, __CONCAT(__,function),suffix, args)
#define __MATHCALLX(function,suffix,args,attrib) __MATHDECLX (_Mdouble_,function,suffix, args, attrib)
#define __MATHDECLX(type,function,suffix,args,attrib) __MATHDECL_1(type, function,suffix, args) __attribute__ (attrib); __MATHDECL_1(type, __CONCAT(__,function),suffix, args) __attribute__ (attrib)
#define __MATHDECL_1(type,function,suffix,args) extern type __MATH_PRECNAME(function,suffix) args __THROW
#define _Mdouble_ double
#define __MATH_PRECNAME(name,r) __CONCAT(name,r)
#define __MATH_DECLARING_DOUBLE 1
#define __MATH_DECLARING_FLOATN 0
#include <bits/mathcalls-helper-functions.h>
#include <bits/mathcalls.h>
#undef _Mdouble_
#undef __MATH_PRECNAME
#undef __MATH_DECLARING_DOUBLE
#undef __MATH_DECLARING_FLOATN
/* Include the file of declarations again, this time using `float'
   instead of `double' and appending f to each function name.  */
#define _Mdouble_ float
#define __MATH_PRECNAME(name,r) name ##f ##r
#define __MATH_DECLARING_DOUBLE 0
#define __MATH_DECLARING_FLOATN 0
#include <bits/mathcalls-helper-functions.h>
#include <bits/mathcalls.h>
#undef _Mdouble_
#undef __MATH_PRECNAME
#undef __MATH_DECLARING_DOUBLE
#undef __MATH_DECLARING_FLOATN
/* Include the file of declarations again, this time using `long double'
   instead of `double' and appending l to each function name.  */
#define _Mdouble_ long double
#define __MATH_PRECNAME(name,r) name ##l ##r
#define __MATH_DECLARING_DOUBLE 0
#define __MATH_DECLARING_FLOATN 0
#define __MATH_DECLARE_LDOUBLE 1
#include <bits/mathcalls-helper-functions.h>
#include <bits/mathcalls.h>
#undef _Mdouble_
#undef __MATH_PRECNAME
#undef __MATH_DECLARING_DOUBLE
#undef __MATH_DECLARING_FLOATN
/* Include the file of declarations for _FloatN and _FloatNx
   types.  */
#define _Mdouble_ _Float32
#define __MATH_PRECNAME(name,r) name ##f32 ##r
#define __MATH_DECLARING_DOUBLE 0
#define __MATH_DECLARING_FLOATN 1
#include <bits/mathcalls.h>
#undef _Mdouble_
#undef __MATH_PRECNAME
#undef __MATH_DECLARING_DOUBLE
#undef __MATH_DECLARING_FLOATN
#define _Mdouble_ _Float64
#define __MATH_PRECNAME(name,r) name ##f64 ##r
#define __MATH_DECLARING_DOUBLE 0
#define __MATH_DECLARING_FLOATN 1
#include <bits/mathcalls.h>
#undef _Mdouble_
#undef __MATH_PRECNAME
#undef __MATH_DECLARING_DOUBLE
#undef __MATH_DECLARING_FLOATN
#define _Mdouble_ _Float128
#define __MATH_PRECNAME(name,r) name ##f128 ##r
#define __MATH_DECLARING_DOUBLE 0
#define __MATH_DECLARING_FLOATN 1
#include <bits/mathcalls-helper-functions.h>
#include <bits/mathcalls.h>
#undef _Mdouble_
#undef __MATH_PRECNAME
#undef __MATH_DECLARING_DOUBLE
#undef __MATH_DECLARING_FLOATN
#define _Mdouble_ _Float32x
#define __MATH_PRECNAME(name,r) name ##f32x ##r
#define __MATH_DECLARING_DOUBLE 0
#define __MATH_DECLARING_FLOATN 1
#include <bits/mathcalls.h>
#undef _Mdouble_
#undef __MATH_PRECNAME
#undef __MATH_DECLARING_DOUBLE
#undef __MATH_DECLARING_FLOATN
#define _Mdouble_ _Float64x
#define __MATH_PRECNAME(name,r) name ##f64x ##r
#define __MATH_DECLARING_DOUBLE 0
#define __MATH_DECLARING_FLOATN 1
#include <bits/mathcalls.h>
#undef _Mdouble_
#undef __MATH_PRECNAME
#undef __MATH_DECLARING_DOUBLE
#undef __MATH_DECLARING_FLOATN
#undef __MATHDECL_1
#undef __MATHDECL
#undef __MATHCALL
/* Declare functions returning a narrower type.  */
#define __MATHCALL_NARROW_ARGS_1 (_Marg_ __x)
#define __MATHCALL_NARROW_ARGS_2 (_Marg_ __x, _Marg_ __y)
#define __MATHCALL_NARROW_ARGS_3 (_Marg_ __x, _Marg_ __y, _Marg_ __z)
#define __MATHCALL_NARROW_NORMAL(func,nargs) extern _Mret_ func __MATHCALL_NARROW_ARGS_ ## nargs __THROW
#define __MATHCALL_NARROW_REDIR(func,redir,nargs) extern _Mret_ __REDIRECT_NTH (func, __MATHCALL_NARROW_ARGS_ ## nargs, redir)
#define __MATHCALL_NARROW(func,redir,nargs) __MATHCALL_NARROW_NORMAL (func, nargs)
#define _Mret_ float
#define _Marg_ double
#define __MATHCALL_NAME(name) f ## name
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ float
#define _Marg_ long double
#define __MATHCALL_NAME(name) f ## name ## l
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ double
#define _Marg_ long double
#define __MATHCALL_NAME(name) d ## name ## l
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float32
#define _Marg_ _Float32x
#define __MATHCALL_NAME(name) f32 ## name ## f32x
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float32
#define _Marg_ _Float64
#define __MATHCALL_NAME(name) f32 ## name ## f64
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float32
#define _Marg_ _Float64x
#define __MATHCALL_NAME(name) f32 ## name ## f64x
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float32
#define _Marg_ _Float128
#define __MATHCALL_NAME(name) f32 ## name ## f128
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float32x
#define _Marg_ _Float64
#define __MATHCALL_NAME(name) f32x ## name ## f64
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float32x
#define _Marg_ _Float64x
#define __MATHCALL_NAME(name) f32x ## name ## f64x
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float32x
#define _Marg_ _Float128
#define __MATHCALL_NAME(name) f32x ## name ## f128
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float64
#define _Marg_ _Float64x
#define __MATHCALL_NAME(name) f64 ## name ## f64x
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float64
#define _Marg_ _Float128
#define __MATHCALL_NAME(name) f64 ## name ## f128
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#define _Mret_ _Float64x
#define _Marg_ _Float128
#define __MATHCALL_NAME(name) f64x ## name ## f128
#include <bits/mathcalls-narrow.h>
#undef _Mret_
#undef _Marg_
#undef __MATHCALL_NAME
#undef __MATHCALL_NARROW_ARGS_1
#undef __MATHCALL_NARROW_ARGS_2
#undef __MATHCALL_NARROW_ARGS_3
#undef __MATHCALL_NARROW_NORMAL
#undef __MATHCALL_NARROW_REDIR
#undef __MATHCALL_NARROW
/* This variable is used by `gamma' and `lgamma'.  */
extern int signgam;
/* Depending on the type of TG_ARG, call an appropriately suffixed
   version of FUNC with arguments (including parentheses) ARGS.
   Suffixed functions may not exist for long double if it has the same
   format as double, or for other types with the same format as float,
   double or long double.  The behavior is undefined if the argument
   does not have a real floating type.  The definition may use a
   conditional expression, so all suffixed versions of FUNC must
   return the same type (FUNC may include a cast if necessary rather
   than being a single identifier).  */
#define __MATH_TG_F32(FUNC,ARGS) _Float32: FUNC ## f ARGS,
#define __MATH_TG_F64X(FUNC,ARGS) _Float64x: FUNC ## l ARGS,
#define __MATH_TG(TG_ARG,FUNC,ARGS) _Generic ((TG_ARG), float: FUNC ## f ARGS, __MATH_TG_F32 (FUNC, ARGS) default: FUNC ARGS, long double: FUNC ## l ARGS, __MATH_TG_F64X (FUNC, ARGS) _Float128: FUNC ## f128 ARGS)
/* ISO C99 defines some generic macros which work on any data type.  */
/* All floating-point numbers can be put in one of these categories.  */
enum
  {
    FP_NAN =
#define FP_NAN 0
      FP_NAN,
    FP_INFINITE =
#define FP_INFINITE 1
      FP_INFINITE,
    FP_ZERO =
#define FP_ZERO 2
      FP_ZERO,
    FP_SUBNORMAL =
#define FP_SUBNORMAL 3
      FP_SUBNORMAL,
    FP_NORMAL =
#define FP_NORMAL 4
      FP_NORMAL
  };
/* GCC bug 66462 means we cannot use the math builtins with -fsignaling-nan,
   so disable builtins if this is enabled.  When fixed in a newer GCC,
   the __SUPPORT_SNAN__ check may be skipped for those versions.  */
/* Return number of classification appropriate for X.  */
     /* The check for __cplusplus allows the use of the builtin, even
	when optimization for size is on.  This is provided for
	libstdc++, only to let its configure test work when it is built
	with -Os.  No further use of this definition of fpclassify is
	expected in C++ mode, since libstdc++ provides its own version
	of fpclassify in cmath (which undefines fpclassify).  */
#define fpclassify(x) __builtin_fpclassify (FP_NAN, FP_INFINITE, FP_NORMAL, FP_SUBNORMAL, FP_ZERO, x)
/* Return nonzero value if sign of X is negative.  */
#define signbit(x) __builtin_signbit (x)
/* Return nonzero value if X is not +-Inf or NaN.  */
#define isfinite(x) __builtin_isfinite (x)
/* Return nonzero value if X is neither zero, subnormal, Inf, nor NaN.  */
#define isnormal(x) __builtin_isnormal (x)
/* Return nonzero value if X is a NaN.  We could use `fpclassify' but
   we already have this functions `__isnan' and it is faster.  */
#define isnan(x) __builtin_isnan (x)
/* Return nonzero value if X is positive or negative infinity.  */
#define isinf(x) __builtin_isinf_sign (x)
/* Bitmasks for the math_errhandling macro.  */
#define MATH_ERRNO 1
#define MATH_ERREXCEPT 2
/* By default all math functions support both errno and exception handling
   (except for soft floating point implementations which may only support
   errno handling).  If errno handling is disabled, exceptions are still
   supported by GLIBC.  Set math_errhandling to 0 with -ffast-math (this is
   nonconforming but it is more useful than leaving it undefined).  */
#define math_errhandling (MATH_ERRNO | MATH_ERREXCEPT)
#include <bits/iscanonical.h>
/* Return nonzero value if X is a signaling NaN.  */
#define issignaling(x) __MATH_TG ((x), __issignaling, (x))
/* Return nonzero value if X is subnormal.  */
#define issubnormal(x) (fpclassify (x) == FP_SUBNORMAL)
/* Return nonzero value if X is zero.  */
#define iszero(x) (((__typeof (x)) (x)) == 0)
/* X/Open wants another strange constant.  */
#define MAXFLOAT 3.40282347e+38F
/* Some useful constants.  */
#define M_E 2.7182818284590452354
#define M_LOG2E 1.4426950408889634074
#define M_LOG10E 0.43429448190325182765
#define M_LN2 0.69314718055994530942
#define M_LN10 2.30258509299404568402
#define M_PI 3.14159265358979323846
#define M_PI_2 1.57079632679489661923
#define M_PI_4 0.78539816339744830962
#define M_1_PI 0.31830988618379067154
#define M_2_PI 0.63661977236758134308
#define M_2_SQRTPI 1.12837916709551257390
#define M_SQRT2 1.41421356237309504880
#define M_SQRT1_2 0.70710678118654752440
/* The above constants are not adequate for computation using `long double's.
   Therefore we provide as an extension constants with similar names as a
   GNU extension.  Provide enough digits for the 128-bit IEEE quad.  */
#define M_El 2.718281828459045235360287471352662498L
#define M_LOG2El 1.442695040888963407359924681001892137L
#define M_LOG10El 0.434294481903251827651128918916605082L
#define M_LN2l 0.693147180559945309417232121458176568L
#define M_LN10l 2.302585092994045684017991454684364208L
#define M_PIl 3.141592653589793238462643383279502884L
#define M_PI_2l 1.570796326794896619231321691639751442L
#define M_PI_4l 0.785398163397448309615660845819875721L
#define M_1_PIl 0.318309886183790671537767526745028724L
#define M_2_PIl 0.636619772367581343075535053490057448L
#define M_2_SQRTPIl 1.128379167095512573896158903121545172L
#define M_SQRT2l 1.414213562373095048801688724209698079L
#define M_SQRT1_2l 0.707106781186547524400844362104849039L
#define M_Ef32 __f32 (2.718281828459045235360287471352662498)
#define M_LOG2Ef32 __f32 (1.442695040888963407359924681001892137)
#define M_LOG10Ef32 __f32 (0.434294481903251827651128918916605082)
#define M_LN2f32 __f32 (0.693147180559945309417232121458176568)
#define M_LN10f32 __f32 (2.302585092994045684017991454684364208)
#define M_PIf32 __f32 (3.141592653589793238462643383279502884)
#define M_PI_2f32 __f32 (1.570796326794896619231321691639751442)
#define M_PI_4f32 __f32 (0.785398163397448309615660845819875721)
#define M_1_PIf32 __f32 (0.318309886183790671537767526745028724)
#define M_2_PIf32 __f32 (0.636619772367581343075535053490057448)
#define M_2_SQRTPIf32 __f32 (1.128379167095512573896158903121545172)
#define M_SQRT2f32 __f32 (1.414213562373095048801688724209698079)
#define M_SQRT1_2f32 __f32 (0.707106781186547524400844362104849039)
#define M_Ef64 __f64 (2.718281828459045235360287471352662498)
#define M_LOG2Ef64 __f64 (1.442695040888963407359924681001892137)
#define M_LOG10Ef64 __f64 (0.434294481903251827651128918916605082)
#define M_LN2f64 __f64 (0.693147180559945309417232121458176568)
#define M_LN10f64 __f64 (2.302585092994045684017991454684364208)
#define M_PIf64 __f64 (3.141592653589793238462643383279502884)
#define M_PI_2f64 __f64 (1.570796326794896619231321691639751442)
#define M_PI_4f64 __f64 (0.785398163397448309615660845819875721)
#define M_1_PIf64 __f64 (0.318309886183790671537767526745028724)
#define M_2_PIf64 __f64 (0.636619772367581343075535053490057448)
#define M_2_SQRTPIf64 __f64 (1.128379167095512573896158903121545172)
#define M_SQRT2f64 __f64 (1.414213562373095048801688724209698079)
#define M_SQRT1_2f64 __f64 (0.707106781186547524400844362104849039)
#define M_Ef128 __f128 (2.718281828459045235360287471352662498)
#define M_LOG2Ef128 __f128 (1.442695040888963407359924681001892137)
#define M_LOG10Ef128 __f128 (0.434294481903251827651128918916605082)
#define M_LN2f128 __f128 (0.693147180559945309417232121458176568)
#define M_LN10f128 __f128 (2.302585092994045684017991454684364208)
#define M_PIf128 __f128 (3.141592653589793238462643383279502884)
#define M_PI_2f128 __f128 (1.570796326794896619231321691639751442)
#define M_PI_4f128 __f128 (0.785398163397448309615660845819875721)
#define M_1_PIf128 __f128 (0.318309886183790671537767526745028724)
#define M_2_PIf128 __f128 (0.636619772367581343075535053490057448)
#define M_2_SQRTPIf128 __f128 (1.128379167095512573896158903121545172)
#define M_SQRT2f128 __f128 (1.414213562373095048801688724209698079)
#define M_SQRT1_2f128 __f128 (0.707106781186547524400844362104849039)
#define M_Ef32x __f32x (2.718281828459045235360287471352662498)
#define M_LOG2Ef32x __f32x (1.442695040888963407359924681001892137)
#define M_LOG10Ef32x __f32x (0.434294481903251827651128918916605082)
#define M_LN2f32x __f32x (0.693147180559945309417232121458176568)
#define M_LN10f32x __f32x (2.302585092994045684017991454684364208)
#define M_PIf32x __f32x (3.141592653589793238462643383279502884)
#define M_PI_2f32x __f32x (1.570796326794896619231321691639751442)
#define M_PI_4f32x __f32x (0.785398163397448309615660845819875721)
#define M_1_PIf32x __f32x (0.318309886183790671537767526745028724)
#define M_2_PIf32x __f32x (0.636619772367581343075535053490057448)
#define M_2_SQRTPIf32x __f32x (1.128379167095512573896158903121545172)
#define M_SQRT2f32x __f32x (1.414213562373095048801688724209698079)
#define M_SQRT1_2f32x __f32x (0.707106781186547524400844362104849039)
#define M_Ef64x __f64x (2.718281828459045235360287471352662498)
#define M_LOG2Ef64x __f64x (1.442695040888963407359924681001892137)
#define M_LOG10Ef64x __f64x (0.434294481903251827651128918916605082)
#define M_LN2f64x __f64x (0.693147180559945309417232121458176568)
#define M_LN10f64x __f64x (2.302585092994045684017991454684364208)
#define M_PIf64x __f64x (3.141592653589793238462643383279502884)
#define M_PI_2f64x __f64x (1.570796326794896619231321691639751442)
#define M_PI_4f64x __f64x (0.785398163397448309615660845819875721)
#define M_1_PIf64x __f64x (0.318309886183790671537767526745028724)
#define M_2_PIf64x __f64x (0.636619772367581343075535053490057448)
#define M_2_SQRTPIf64x __f64x (1.128379167095512573896158903121545172)
#define M_SQRT2f64x __f64x (1.414213562373095048801688724209698079)
#define M_SQRT1_2f64x __f64x (0.707106781186547524400844362104849039)
/* When compiling in strict ISO C compatible mode we must not use the
   inline functions since they, among other things, do not set the
   `errno' variable correctly.  */
/* ISO C99 defines some macros to compare number while taking care for
   unordered numbers.  Many FPUs provide special instructions to support
   these operations.  Generic support in GCC for these as builtins went
   in 2.97, but not all cpus added their patterns until 3.1.  Therefore
   we enable the builtins from 3.1 onwards and use a generic implementation
   othwerwise.  */
#define isgreater(x,y) __builtin_isgreater(x, y)
#define isgreaterequal(x,y) __builtin_isgreaterequal(x, y)
#define isless(x,y) __builtin_isless(x, y)
#define islessequal(x,y) __builtin_islessequal(x, y)
#define islessgreater(x,y) __builtin_islessgreater(x, y)
#define isunordered(x,y) __builtin_isunordered(x, y)
/* Get machine-dependent inline versions (if there are any).  */
/* An expression whose type has the widest of the evaluation formats
   of X and Y (which are of floating-point types).  */
#define __MATH_EVAL_FMT2(x,y) ((x) + (y) + 0.0f)
/* Return X == Y but raising "invalid" and setting errno if X or Y is
   a NaN.  */
#define iseqsig(x,y) __MATH_TG (__MATH_EVAL_FMT2 (x, y), __iseqsig, ((x), (y)))
__END_DECLS
#endif /* __MATH_H__ */
