#ifndef __IOCTL_H__
#define __IOCTL_H__
/* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note */
#define __HDLC_IOCTL_H__ 
#define GENERIC_HDLC_VERSION 4
#define CLOCK_DEFAULT 0
#define CLOCK_EXT 1
#define CLOCK_INT 2
#define CLOCK_TXINT 3
#define CLOCK_TXFROMRX 4
#define ENCODING_DEFAULT 0
#define ENCODING_NRZ 1
#define ENCODING_NRZI 2
#define ENCODING_FM_MARK 3
#define ENCODING_FM_SPACE 4
#define ENCODING_MANCHESTER 5
#define PARITY_DEFAULT 0
#define PARITY_NONE 1
#define PARITY_CRC16_PR0 2
#define PARITY_CRC16_PR1 3
#define PARITY_CRC16_PR0_CCITT 4
#define PARITY_CRC16_PR1_CCITT 5
#define PARITY_CRC32_PR0_CCITT 6
#define PARITY_CRC32_PR1_CCITT 7
#define LMI_DEFAULT 0
#define LMI_NONE 1
#define LMI_ANSI 2
#define LMI_CCITT 3
#define LMI_CISCO 4
typedef struct {
	unsigned int clock_rate; /* bits per second */
	unsigned int clock_type; /* internal, external, TX-internal etc. */
	unsigned short loopback;
} sync_serial_settings;          /* V.35, V.24, X.21 */
typedef struct {
	unsigned int clock_rate; /* bits per second */
	unsigned int clock_type; /* internal, external, TX-internal etc. */
	unsigned short loopback;
	unsigned int slot_map;
} te1_settings;                  /* T1, E1 */
typedef struct {
	unsigned short encoding;
	unsigned short parity;
} raw_hdlc_proto;
typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	unsigned short lmi;
	unsigned short dce; /* 1 for DCE (network side) operation */
} fr_proto;
typedef struct {
	unsigned int dlci;
} fr_proto_pvc;          /* for creating/deleting FR PVCs */
typedef struct {
	unsigned int dlci;
	char master[IFNAMSIZ];	/* Name of master FRAD device */
}fr_proto_pvc_info;		/* for returning PVC information only */
typedef struct {
    unsigned int interval;
    unsigned int timeout;
} cisco_proto;
/* PPP doesn't need any info now - supply length = 0 to ioctl */
#endif /* __IOCTL_H__ */
