#ifndef __ASSERT_H__
#define __ASSERT_H__
/* Copyright (C) 1991-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
/*
 *	ISO C99 Standard: 7.2 Diagnostics	<assert.h>
 */
#define _ASSERT_H 1
#include <features.h>
#define __ASSERT_VOID_CAST (void)
/* void assert (int expression);
   If NDEBUG is defined, do nothing.
   If not, and EXPRESSION is zero, print an error message and abort.  */
#define assert(expr) (__ASSERT_VOID_CAST (0))
/* void assert_perror (int errnum);
   If NDEBUG is defined, do nothing.  If not, and ERRNUM is not zero, print an
   error message with the error text for ERRNUM and abort.
   (This is a GNU extension.) */
#define assert_perror(errnum) (__ASSERT_VOID_CAST (0))
#undef static_assert
#define static_assert _Static_assert
#endif /* __ASSERT_H__ */
