#ifndef __POSIX_TYPES_H__
#define __POSIX_TYPES_H__
/* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note */
#define __ASM_GENERIC_POSIX_TYPES_H 
#include <asm/bitsperlong.h>
/*
 * This file is generally used by user-level software, so you need to
 * be a little careful about namespace pollution etc.
 *
 * First the types that are often defined in different ways across
 * architectures, so that you can override them.
 */
typedef long		__kernel_long_t;
typedef unsigned long	__kernel_ulong_t;
typedef __kernel_ulong_t __kernel_ino_t;
typedef unsigned int	__kernel_mode_t;
typedef int		__kernel_pid_t;
typedef int		__kernel_ipc_pid_t;
typedef unsigned int	__kernel_uid_t;
typedef unsigned int	__kernel_gid_t;
typedef __kernel_long_t		__kernel_suseconds_t;
typedef int		__kernel_daddr_t;
typedef unsigned int	__kernel_uid32_t;
typedef unsigned int	__kernel_gid32_t;
/*
 * Most 32 bit architectures use "unsigned int" size_t,
 * and all 64 bit architectures use "unsigned long" size_t.
 */
typedef __kernel_ulong_t __kernel_size_t;
typedef __kernel_long_t	__kernel_ssize_t;
typedef __kernel_long_t	__kernel_ptrdiff_t;
typedef struct {
	int	val[2];
} __kernel_fsid_t;
/*
 * anything below here should be completely generic
 */
typedef __kernel_long_t	__kernel_off_t;
typedef long long	__kernel_loff_t;
typedef __kernel_long_t	__kernel_time_t;
typedef long long __kernel_time64_t;
typedef __kernel_long_t	__kernel_clock_t;
typedef int		__kernel_timer_t;
typedef int		__kernel_clockid_t;
typedef char *		__kernel_caddr_t;
typedef unsigned short	__kernel_uid16_t;
typedef unsigned short	__kernel_gid16_t;
#endif /* __POSIX_TYPES_H__ */
